//------------------------------------------------------------------------------
// File: DeadMine.cs
// Controls the dead mine scenario tasks
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$DeadMine::DynamiteCost = 80;
$Dynamite::DynamiteHorseName = "shophorse";
$DeadMine::ConvertMine = false;
$DeadMine::AddVein = false;

//-Dead Mine Helper Functions---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Activates the dead mine tasks
////////////////////////////////////////////////////////////////////////////////
function startDeadMineTasks()
{
   InitializeQuestGui();
   slgTrain_DisableTrains();
   // disable build button
   tsEnableCommand(BuildCmdData, false);
   
   tsStartTask("DeadMine", tsGetStartingVertexes("DeadMine"));
   tsStartTask("Dynamite", tsGetStartingVertexes("Dynamite"));
   tsStartTask("HorseRescue", tsGetStartingVertexes("HorseRescue"));
   
   // Clear globals
   $DeadMine::ConvertMine = false;
   $DeadMine::AddVein = false;
}

////////////////////////////////////////////////////////////////////////////////
//! Deactivates the dead mine tasks
////////////////////////////////////////////////////////////////////////////////
function endDeadMineTasks()
{
   // Set globals
   if(DeadMineSellMine.hasBeenCompleted()) {
      $DeadMine::ConvertMine = true;
   }
   if(DeadMineFindTreasure.hasBeenCompleted()) {
      $DeadMine::AddVein = true;
   }
   // build button
   tsEnableCommand(BuildCmdData, true);
   
   tsEndTask("HorseRescue");
   tsEndTask("Dynamite");
   tsEndTask("DeadMine");
}
function resetDeadMineTasks()
{
   TaskModifier.strMarkVertex("MainmapTasks", "MainDeadmineResetDelay", $TSV_AVAIL);
}
////////////////////////////////////////////////////////////////////////////////
//! Called when returning to the main map and done loading
////////////////////////////////////////////////////////////////////////////////
function winDeadMineTasks()
{
   // Change dead mine on main map if needed
   if($DeadMine::ConvertMine) {
      if(isObject(deadminegold)) {
         %bTeamSet = false;
         %bldgs = slgGetServerBuildingList();
         %count = %bldgs.getSize();
         for(%i = 0; %i < %count; %i++) {
            %bldg = %bldgs.getID(%i);
            // Swap team if true
            if(%bldg.getPosition() $= deadminegold.getPosition()) {
               %bldg.setTeam($OST_NEUTRAL);
               %bTeamSet = true;
               break;
            }
         }
         // Building not on deadmine. Spawn one there
         if(!%bTeamSet) {
            %bldg = tsCreateObj("Goldmine", "", $OST_NEUTRAL, deadminegold.getPosition());
            %cmpBldg = slgQueryInterface(%bldg, $CID_BUILDING);
            %cmpBldg.setState($BuildingState::Production);
         }
         %obj = tsCreateObj("MaleCiv", "", $OST_NEUTRAL, "-125 -128");
         tsMountImageOnObj(%obj, "Pickaxe");
         tsMountImageOnObj(%obj, "Minerhat");
         tsSkinObj(%obj, "default");
      }
   }
   
   // Spawn new gold mine on main map if needed
   if($DeadMine::AddVein) {
      if(isObject(DMhiddengold)) {
         tsCreateObj("goldvein", "", $OST_NEUTRAL, DMhiddengold.getPosition());
         tsRemoveObj("DMhiddengold");
      }
   }
   SetBuildingGoldRate(1);
   tsEnableCommand(BuildCmdData, true);
   tsCompleteTaskInTracker("Dead Mine", "Investigate the mining camp across the river.");
   TaskModifier.strMarkVertex("MainmapTasks", "DeadmineComplete", $TSV_AVAIL);
   //Reward
   tsModifyResource($Resource::Experience, 10, true);   
   SendProductionToClient(HeroCharacter, "10 experience");
}

////////////////////////////////////////////////////////////////////////////////
//! Returns true if the shop horse has been obtained
//! \retval bool True if the horse is obtained
////////////////////////////////////////////////////////////////////////////////
function deadMineShopHorseObtained()
{
   return (shophorse.isOnTeam($OST_PLAYER));
}

////////////////////////////////////////////////////////////////////////////////
//! Sends the dialog for selling dynamite after completion of the horse rescue
////////////////////////////////////////////////////////////////////////////////
function deadMineSendDynamiteSellDlg()
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_CHEAPDYNAMITE", true, $TaskButton::Accept, "id_dm_boughtdynamite");
   tsAddTaskDialog("id_dm_selldynamite", %dlgData);
   tsAddAcceptCost($Resource::Gold, $DeadMine::DynamiteCost, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "tntdude");
   tsDestroyTaskDlgData(%dlgData);
}

////////////////////////////////////////////////////////////////////////////////
//! Returns a random team object from the team object list, excluding a certain
//! horse if present
//! \param %objList List of game objects
//! \retval integer Id of game object chosen
////////////////////////////////////////////////////////////////////////////////
function deadMineGetRandomObjectFromList(%objList)
{
   %count = %objList.getSize();
   if(%count <= 0) {
      return 0;
   }
   
   for(%i = 0; %i < %count; %i++) {
      %obj = %objList.getID(%i);
      if(%obj.getName() $= $Dynamite::DynamiteHorseName) {
         break;
      }
   }
   
   // No horse found
   if(%i == %count) {
      return %objList.getRandomObject();
   }   
   // Horse found
   else {
      if(%count > 1) {
         %val = getRandom(0, %count - 2);
         if(%val == %i) {
            %val++;
         }
         return %objList.getID(%val);
      }
      // If this is true then only the horse is selected, so we choose the hero
      // by default
      else {
         return HeroCharacter.getId();
      }
   }
}
////////////////////////////////////////////////////////////////////////////////
//! This function gets the bandit type (gender) from the civilian type that
//! spawned it
////////////////////////////////////////////////////////////////////////////////
function deadMineGetBanditType(%obj)
{
   %cmpChar = slgQueryInterface(%obj.getId(), $CID_CHARACTER);
   if(%cmpChar.getDataBlock().gender == $GENDER_MALE) {
      return Malebandit;
   }
   else {
      return Femalebandit;
   }
}

//-DeadMineIntro Vertex---------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for initializing the scenario on entry
////////////////////////////////////////////////////////////////////////////////
function DeadMineIntro::onExit(%this)
{
   Parent::onExit(%this);
   
   // Send intro dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_intro", $TaskButton::Okay, "HeroCharacter");
   
   // Quest Log
   tsAddQuestToTracker(true, "Dead Mine", "", "Find out where all the Gold has been going and exactly who is behind its disappearance.");
   tsReadyQuest("Dead Mine");
   tsAddTaskToTracker("Dead Mine", "Find out what's happening to the Gold.", "Search through the caverns to see why your Mine is running low on Gold.");
}
//-DeadMineLose Vertex----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Player's game ends once the player has no combat units and the hero is 
// disabled
////////////////////////////////////////////////////////////////////////////////
function DeadMineLose::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   if(HeroCharacter.isHealing && !tsCombatUnitsExist($OST_PLAYER)) {
      tsRestartScenario();
   }
}

//-DeadMineCaveWallZone Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for monitoring when the player moves one of 
// his/her team units into the cave wall zone and displaying a pop-up dialog
////////////////////////////////////////////////////////////////////////////////
function DeadMineCaveWallZone::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   // Send popup dialog
   if(%this.isMarkedComplete()) {
      // Get random object from list
      %objs = tsGetObjListFromMsg(%msg, %params);
      %char = deadMineGetRandomObjectFromList(%objs);
      
      // Pop-up dialog with this object
      tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_cavewall", $TaskButton::Okay, %char);
      
      //Quest log
      tsAddQuestToTracker(false, "Golden Secret", "", "On the cave wall it reads, 'Find the tomb where the still water runs clear for a golden secret.'");
      tsReadyQuest("Golden Secret");
      tsAddTaskToTracker("Golden Secret", "Locate the tomb.", "Find the mysterious tomb where the still water runs clear.");
   
   }
}
//-DeadMineTombZone Vertex------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for monitoring when the player moves one of 
// his/her team units into the tomb zone and displaying a pop-up dialog
////////////////////////////////////////////////////////////////////////////////
function DeadMineTombZone::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   // Send popup dialog
   if(%this.isMarkedComplete()) {
      %objs = tsGetObjListFromMsg(%msg, %params);
      %char = deadMineGetRandomObjectFromList(%objs);
      tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_tomb", $TaskButton::Okay, %char);
   }
}
//-DeadMineFindTreasure Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for catching when the white rock is destroyed, 
// upon which it creates the gold vein in its place. If this vertex is completed
// then a gold vein is created on the main map
////////////////////////////////////////////////////////////////////////////////
function DeadMineFindTreasure::onExit(%this)
{
   Parent::onExit(%this);
  
   tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_cavewallgoldmine", $TaskButton::Okay, "herocharacter");
    // Quest log
   tsCompleteTaskInTracker("Golden Secret", "Locate the tomb.");
   // Spawn gold vein on this map
   //tsCreateObj("goldvein", "", $OST_NONE, "-226 -140");
}
//------------------------------------------------------------------------------

/******************************************************************************/
/** DYNAMITE TASK
/******************************************************************************/
//-DynamiteStoreZone Vertex-----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for capturing the zone of a player unit into the
// storezone and then displaying the introduction dialog to the dynamite task
////////////////////////////////////////////////////////////////////////////////
function DynamiteStoreZone::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   // If completed then display introductory dialog   
   if(%this.isMarkedComplete()) 
   {
      %objs = tsGetObjListFromMsg(%msg, %params);
      %char = deadMineGetRandomObjectFromList(%objs);
      
      tsSendTaskPopUpDlg("ID_TASKNAME_CHEAPDYNAMITE", "id_dm_storezone", $TaskButton::Okay, "tntdude");
      tsSendTaskPopUpDlg("ID_TASKNAME_CHEAPDYNAMITE", "id_dm_aboutfriend", $TaskButton::Okay, %char);
      tsSendTaskPopUpDlg("ID_TASKNAME_CHEAPDYNAMITE", "id_dm_explainfriend", $TaskButton::Okay, "tntdude");
      tsSendTaskPopUpDlg("ID_TASKNAME_CHEAPDYNAMITE", "id_dm_offerdynamite", $TaskButton::Okay, "tntdude", "id_dm_offerdynamite");
      
      // Quest log
      tsAddQuestToTracker(true, "A Dynamite Deal", "", "Rescue the shoppkeep's best friend from the bandits that horse-napped her.", "Reward: The shopkeep's goodwill.");      
      tsReadyQuest("A Dynamite Deal");
      tsAddTaskToTracker("A Dynamite Deal", "Find the kidnapped horse.", "Bring back the shopkeep's best friend so he'll sell you Dynamite.");
   
   }
}
function DynamiteStoreRescue::onExit(%this)
{
   Parent::onExit(%this);
   // If horse has already been obtained then
   if(deadMineShopHorseObtained()) 
   {
      // Display dialog and mark return to store complete
      tsSendTaskPopUpDlg("ID_TASKNAME_CHEAPDYNAMITE", "id_dm_alreadyhavehorse", $TaskButton::Okay, "HeroCharacter");
      
      //Quest log
      tsAddTaskToTracker("A Dynamite Deal", "Return the horse to the Store.", "Bring back the shopkeep's best friend so he'll sell you Dynamite");
      tsCompleteTaskInTracker("A Dynamite Deal", "Find the kidnapped horse.");
      
   }
   // Don't have horse yet
   else 
   {
      tsActivateVertexes("Dynamite", "DynamiteHorseCheck");
   }

}
//-DynamiteHorseCheck Vertex----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for checking if the player has obtained a horse
////////////////////////////////////////////////////////////////////////////////
function DynamiteHorseCheck::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   // We've got horse so exit
   if(deadMineShopHorseObtained()) 
   {
      tsCompleteVertexes("Dynamite", "DynamiteHorseCheck");    
      //Quest log 
      tsAddTaskToTracker("A Dynamite Deal", "Return the horse to the Store.", "Bring back the shopkeep's best friend so he'll sell you Dynamite");     
      tsCompleteTaskInTracker("A Dynamite Deal", "Find the kidnapped horse.");
   }
}
//-DynamiteStoreZoneReturn Vertex-----------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for catching when the player returns to the store
// zone after the horse has been obtained
////////////////////////////////////////////////////////////////////////////////
function DynamiteStoreZoneReturn::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.isMarkedComplete()) 
   {
      // Give dialog about returning horse
      %objs = tsGetObjListFromMsg(%msg, %params);
      %char = deadMineGetRandomObjectFromList(%objs);
   
      tsSendTaskPopUpDlg("ID_TASKNAME_CHEAPDYNAMITE", "id_dm_havehorse", $TaskButton::Okay, %char);
      if(shophorse.isInZone(storezone))
      {
         TaskModifier.strMarkVertex("Dynamite", "DynamiteHorseReturn", $TSV_CMPLETE);
      }
   }
}
//-DynamiteHorseReturn Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for catching when the horse returns to the store
// zone after all dialog has been given
////////////////////////////////////////////////////////////////////////////////
function DynamiteHorseReturn::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog about being glad to have horse back
   tsSendTaskPopUpDlg("ID_TASKNAME_CHEAPDYNAMITE", "id_dm_bestfriendback", $TaskButton::Okay, "tntdude");
   tsConvertObjTeam($Dynamite::DynamiteHorseName, $OST_NEUTRAL);
   
   //Quest log
   tsCompleteTaskInTracker("A Dynamite Deal", "Return the horse to the Store.");
   deadMineSendDynamiteSellDlg();
}
//-DynamiteSellDynamite Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for selling dynamite continuously to player if
// they have enough money after successfully completing horse quest
////////////////////////////////////////////////////////////////////////////////
function DynamiteSellDynamite::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   // Dynamite bought..reset dialog   
   if(%this.isMarkedComplete()) 
   {
      TaskModifier.strResetVertex("Dynamite", "DynamiteSellDynamite");
      tsActivateVertexes("Dynamite", "DynamiteSellDynamite");
      deadMineSendDynamiteSellDlg();
      
      // Add dynamite to inventory
      %client = ClientGroup.getObject(0);
      %slot = invGetSlotForItem(%client, $INV_DYNAMITE);
      invPushItemInInventory(%client, %slot);
   }
}

/******************************************************************************/
/** BANDIT THREAT TASK
/******************************************************************************/
//-DeadMineGoldZone Vertex------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for monitoring when the player enters the gold 
// zone and outputting a warning message
////////////////////////////////////////////////////////////////////////////////
function DeadMineGoldZone::onExit(%this)
{
   Parent::onExit(%this);
   
   tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_goldzonewarn", $TaskButton::Okay, "miner1");
}
//-DeadMineCombatGoldZone Vertex------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for monitoring when the player enters the combat 
// gold zone and outputting a combat message in addition to converting miners
// to bandits
////////////////////////////////////////////////////////////////////////////////
function DeadMineCombatGoldZone::onExit(%this)
{
   Parent::onExit(%this);
   
   %obj = tsCreateObj("Malebandit", "", $OST_BANDIT, "-230 -276", "miner1");
   %obj.name = miner1.name;
   tsMountImageOnObj(%obj, "Minerhat");
   %obj = tsCreateObj("Malebandit", "", $OST_BANDIT, "-227 -263", "miner2");
   %obj.name = miner2.name;
   tsMountImageOnObj(%obj, "Minerhat");
   tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_goldzoneattack", $TaskButton::Okay, %obj);
   
   miner1.DeleteObject();
   miner2.DeleteObject();
}
//-DeadMineCombatGoldZoneWait Vertex--------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for waiting a set amount of time before displaying
// a winning popup dialog after defeating the two bandits in the gold zone
////////////////////////////////////////////////////////////////////////////////
function DeadMineCombatGoldZoneWait::onExit(%this)
{
   Parent::onExit(%this);
   
   tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_goldzonewin", $TaskButton::Okay, "HeroCharacter");
}



/******************************************************************************/
/** HORSE RESCUE TASK
/******************************************************************************/
//-HorseRescueHorseFound Vertex-------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex handles the starting case of the horse rescue task, that is when
// the player first moves a unit into the starting zone.  A choice is given
// to the player for obtaining the horse if the player has spoken with the civ
// that lost the horse: fight or pay. Otherwise, just pay is given as a choice
////////////////////////////////////////////////////////////////////////////////
function HorseRescueHorseFound::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.isMarkedComplete()) 
   {
      tsSendTaskPopUpDlg("ID_TASKNAME_HORSERESCUE", "id_dm_horserescuefound", $TaskButton::Okay, "horseciv1");
      
      // You get the option to fight for horse if this is true
      if(DynamiteStoreZone.isComplete()) {
         tsSendTaskClickDlg("ID_TASKNAME_HORSERESCUE", "id_dm_horserescuefight", $TaskButton::Accept, "HeroCharacter", "id_dm_horserescuefight");
      }
      
      // Send payment option
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_HORSERESCUE", true, $TaskButton::Accept, "id_dm_horserescuepay");
      tsAddAcceptCost($Resource::Gold, 100, %dlgData);
      tsAddTaskDialog("id_dm_horserescuepay", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "horseciv1");
      tsDestroyTaskDlgData(%dlgData);
   }
}
function HorseRescuePay::onEnter(%this)
{
   echo("Rescue pay enter");
}
//-HorseRescuePay Vertex--------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Horse is obtained through payment
////////////////////////////////////////////////////////////////////////////////
function HorseRescuePay::onExit(%this)
{
   Parent::onExit(%this);

   tsSendTaskPopUpDlg("ID_TASKNAME_HORSERESCUE", "id_dm_horserescuepaid", $TaskButton::Okay, "horseciv1");
      
   // Destroy dialog for fighting
   tsDestroyTaskDlgIcon("id_dm_horserescuefight", "HeroCharacter");
   
   TaskModifier.strMarkVertex("HorseRescue", "HorseRescueReceiveHorse", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("HorseRescue", "HorseRescueZoneFight", $TSV_CLOSED);
         
   // Complete all vertexes on other path in order
   //tsCompleteVertexes("HorseRescue", "HorseRescueFight" SPC "HorseRescueZoneFight" SPC "HorseRescueDefeatBandits");
}
//-HorseRescueFight Vertex------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Player has opted to fight for the horse
////////////////////////////////////////////////////////////////////////////////
function HorseRescueFight::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.isMarkedComplete()) {
      tsSendTaskPopUpDlg("ID_TASKNAME_HORSERESCUE", "id_dm_horserescueattack", $TaskButton::Okay, "horseciv1");
      
      // Destroy dialog for paying
      //tsDestroyTaskDlgIcon("id_dm_horserescuepay", "horseciv1");
      
      // Complete zone fight path
      tsCompleteVertexes("HorseRescue", "HorseRescueZoneFight");
   }
}
//-HorseRescueZoneFight Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Player has gotten to close to the horse, bandits atttack
////////////////////////////////////////////////////////////////////////////////
function HorseRescueZoneFight::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.isMarkedComplete()) 
   {
      
      if(!(HorseRescueFight.isMarkedComplete())) 
      {      
         if(HorseRescuePay.isMarkedComplete() == true)
         {
            TaskModifier.strMarkVertex("HorseRescue", "HorseRescueFightDelay", $TSV_CLOSED);
            return;
         }
         else
         { 
            tsSendTaskPopUpDlg("ID_TASKNAME_HORSERESCUE", "id_dm_horserescuezonefight", $TaskButton::Okay, "horseciv1");
         }
      }
      // Complete fight path
      //tsCompleteVertexes("HorseRescue", "HorseRescueFight");
   }
}
function HorseRescueFightDelay::onEnter(%this)
{
   // Destroy dialogs for paying and fighting
   tsDestroyTaskDlgIcon("id_dm_horserescuefight", "HeroCharacter");
   tsDestroyTaskDlgIcon("id_dm_horserescuepay", "horseciv1");  
}

//-HorseRescueDefeatBandits Vertex----------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is completed once the player has defeated all the bandits
////////////////////////////////////////////////////////////////////////////////
function HorseRescueDefeatBandits::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Spawn bandits
   %obj1 = tsCreateObj("Femalebandit", "", $OST_BANDIT, "-205 -356", "horseciv1");
   %obj1.name = horseciv1.name;
   %obj2 = tsCreateObj("Malebandit", "", $OST_BANDIT, "-195 -358", "horseciv2");
   %obj2.name = horseciv2.name;
   %obj3 = tsCreateObj("Malebandit", "", $OST_BANDIT, "-202 -368", "horseciv3");
   %obj3.name = horseciv3.name;
   horseciv1.DeleteObject();
   horseciv2.DeleteObject();
   horseciv3.DeleteObject();
   %obj1.setname("horseciv1");
   
   horseBanditsDialog();
}
function horseBanditsDialog()
{
   tsSendTaskPopUpDlg("ID_TASKNAME_HORSERESCUE", "id_dm_horserescueforce", $TaskButton::Okay, "horseciv1");
}

function HorseRescueDefeatBandits::onExit(%this)
{
   Parent::onExit(%this);
   
   tsSendTaskPopUpDlg("ID_TASKNAME_HORSERESCUE", "id_dm_horserescuewinfight", $TaskButton::Okay, "HeroCharacter");
   //tsCompleteVertexes("HorseRescue", "HorseRescuePay");
}
//-HorseRescueReceiveHorse Vertex-----------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Horse has been received through one of the various methods. Swap team for 
// horse
////////////////////////////////////////////////////////////////////////////////
function HorseRescueReceiveHorse::onEnter(%this)
{
   Parent::onEnter(%this);
   
   tsConvertObjTeam("shophorse", $OST_PLAYER);
   tsInternalNameObj("shophorse", "shophorse");
   //Move horse out of pen
   tsMoveObjToTarget("shophorse", "-187 -356");
   tsCompleteVertexes("HorseRescue", "HorseRescueReceiveHorse");
}


/******************************************************************************/
/** FINAL CONFRONTATION
/******************************************************************************/
//-DeadMineOutsideWall Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex captures the moment the player directs his/her units into the
// outside wall zone that leads to the final confrontation with the bandits
////////////////////////////////////////////////////////////////////////////////
function DeadMineOutsideWall::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.isMarkedComplete()) {
      %objs = tsGetObjListFromMsg(%msg, %params);
      %char = deadMineGetRandomObjectFromList(%objs);
      tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_outsidewall", $TaskButton::Okay, %char);
   }
}
//-DeadMineBanditCamp Vertex----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Monitors when the player directs his/her units into the bandit camp zone for
// dialog with the bandits.
////////////////////////////////////////////////////////////////////////////////
function DeadMineBanditCamp::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.isMarkedComplete()) {
      tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_banditcamp", $TaskButton::Okay, "DMbandit1");
   }
}
function DeadMineBanditCamp::onExit(%this)
{
   Parent::onExit(%this);
   
   tsSendTaskClickDlg("ID_DEADMINE_sellgoldmine", "id_dm_sellmine", $TaskButton::Accept, "HeroCharacter", "id_dm_sellmine");
   tsSendTaskClickDlg("ID_DEADMINE_fightgoldmine", "id_dm_fightformine", $TaskButton::Accept, "HeroCharacter", "id_dm_fightformine");
}
//-DeadMineSellMine Vertex------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is completed if the player opts to sell the dead mine to the
// npcs
////////////////////////////////////////////////////////////////////////////////
function DeadMineSellMine::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.hasBeenCompleted()) {
      tsModifyResource($Resource::Gold, 500, true);
      tsDestroyTaskDlgIcon("id_dm_fightformine", "HeroCharacter");
      tsSendTaskPopUpDlg("ID_TASKNAME_DEADMINE", "id_dm_soldgoldmine", $TaskButton::Okay, "DMbandit1");
      tsCompleteVertexes("DeadMine", "DeadMineFightForMine" SPC "DeadMineFightForMineWin");
   }
}
//-DeadMineFightForMine Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completed if the player opts to fight for the mine instead of sell it
////////////////////////////////////////////////////////////////////////////////
function DeadMineFightForMine::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   if(%this.hasBeenCompleted()) {
      tsDestroyTaskDlgIcon("id_dm_sellmine", "HeroCharacter");
      tsCompleteVertexes("DeadMine", "DeadMineSellMine");
      
      // Swap all civs to male and female bandits
      for(%i = 1; %i <= 4; %i++) {
         %bandit = "DMbandit" @ %i;
         %obj = tsCreateObj(deadMineGetBanditType(%bandit), "", $OST_BANDIT, %bandit.getPosition(), %bandit);
         %obj.name = %bandit.name;
         %bandit.DeleteObject();
      }
   }
}
//-DeadMineFightForMineWin Vertex-----------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is here in case any extra dialog is needed in addition to
// progressing the task once all bandits have been defeated
////////////////////////////////////////////////////////////////////////////////
function DeadMineFightForMineWin::onExit(%this)
{
   Parent::onExit(%this);
}
//-DeadMineReturnToMainMap------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Launches the dialog to return to the main map and loads the scenario once
// accepted
////////////////////////////////////////////////////////////////////////////////
function DeadMineReturnToMainMap::onEnter(%this)
{
   Parent::onEnter(%this);
   
   tsSendTaskClickDlg("ID_TASKNAME_DEADMINE", "id_dm_returntomain", $TaskButton::Accept, "HeroCharacter", "id_dm_returntomain");
}
function DeadMineReturnToMainMap::onExit(%this)
{
   Parent::onExit(%this);
   
   // Launch scenario to return to main map
   %scenario  = new SLScenario() {
      stack = false;
   };
   LoadScenario(%scenario, endDeadMineTasks, winDeadMineTasks, "");
   
   // complete the dead mine satellite
   mapsatellite_deadmine.disabled = false;
}

// End DeadMine.cs